#########################################################################################################
# Analysis for the paper  - Factors Affecting User's Behavioral Intention and Use of a Mobile-Phone-
# Delivered Cognitive Behavioral Therapy for Insomnia: a Small-Scale UTAUT Analysis
# Section: Data Characteristics
# 2018 TUDelft
# Output file "description_missingdata.txt" will be created 
#
# required datafiles
# - 89_beforeimputation.sav
#########################################################################################################

#adjust this to folder that contain data files
setwd("/Users/Siska/Documents/temp-berkas/my work/Corine's paper/BMC/stat/")

########### libraries
library(foreign)
library(MASS)
library(psych)
###########

################################################# Data ##########################################################################
d89=read.spss("Acceptance research/smartpls scripts, data & results/Data/89_beforeImputation.sav", to.data.frame=TRUE, use.value.labels = FALSE, reencode=NA)

# direct output to a file 
sink("Acceptance research/r results/description_missingdata.txt", append=FALSE, split=FALSE)

# data fields
# PPnr: Participant number
# conditie: Trial condition, 0 <- waiting list, 1 <- app 
# Performance Expectancy:
# PE1	The SleepCare app provides me information about sleep
# PE2	I feel relax assisting by the SleepCare app
# PE3	The SleepCare app helps me to sleep better
# PE4	The SleepCare app provides me clear insight about my sleep pattern
# PE5	The SleepCare app provides me enough controls over my own intervention
# PE6	Using the SleepCare app, I can do the exercises independently and stay anonymous 
# PE7	The SleepCare app fits my personality
#
# Effort Expectancy:
# EE1	The use of the SleepCare app gives me no ambiguities
# EE2	The SleepCare app is easy to use
# EE3	Learning to work with the SleepCare app is easy for me
# EE4	Utilizing the app gives me little trouble
# EE5_R	Using the SleepCare app is too complicated so I find it hard to understand
# EE6	The app fits in with my daily life
#
# Social Influence
# SI1	I think that my friends would recommend me to use the SleepCare app
# SI2	I think that my family would think I should use the SleepCare app
# SI3	I think that the people in my work environment would encourage me to use the SleepCare app
# SI4	I think that other people with sleep problems would encourage me to use the SleepCare app
# SI5_R	I think that my surrounding would think negatively to a person who use the SleepCare app 
#
# Self_Efficacy
# SE1	I can work well with the SleepCare app without help from others
# SE2	I will be able to use the SleepCare app as long as nothing abnormal happens
# SE3	I can work independently with the SleepCare app
# SE4	I am sure that I'm using the SleepCare app in a good way
#
# Trust
# TR1	I trust the information that SleepCare app provides me with
# TR2_R	I think the SleepCare app will put my privacy at risk
# TR3	I am confident that the SleepCare app will work well
#
# Hedonic Motivation
# HM1	Using the SleepCare app is a good idea
# HM2_R	I hate using the SleepCare app
# HM3	I find that using the SleepCare app is fun
# HM4	I find that using the SleepCare app is interesting
# HM5	The SleepCare app gives me the feeling that my problem is taken seriously
# HM6	The approach of the SleepCare app makes me feel safe
# HM7_R	I feel apprehensive when using the SleepCare app
#
# Anxiety
# AN1_R	I'm worried about using the app
# AN2_R	I'm sometime afraid of losing information if I press a wrong button 
# AN3_R	I'm afraid to make mistakes in the SleepCare app that I cannot turn them back
# AN4_R	I feel somewhat intimidated by the SleepCare app 
#
# Behavioral Intention
# BI1	I will definitely finish the training
# BI2	I will definitely fill in the sleep diary everyday
# BI3	I will definitely do the relaxation exercise everyday
# BI4	I will certainly stay compliant to the bedtimes that I have agreed with the coach
# BI5	I am going to follow up on the sleep tips
# BI6	I am going to fill in my sleep_times in the sleep diary as well as possible
# BI7	I am going to take the time to do the relaxation exercise everyday 
#
# Facilitating Condition
# FC1	I have enough knowledge necessary for using the SleepCare app
# FC2	My mobile phone works perfectly for running the SleepCare app
# FC3	Where necessary, the SleepCare team will help me to use the SleepCare app
# FC4	Where necessary, my friends and/or family will help me to use the SleepCare app
#
# User Behavioral Data:
# SD_DO	The number of days a participant entered the sleep diary
# CONV_DO	The number of completed conversations
# RE_DO	The number of days the participant completed one or more relaxation exercise

cat("\n OUTLIER of the SLEEP APP ACCEPTANCE QUESTIONNAIRE \n\n")
na_89<-c(sum(is.na(d89$BI1)),sum(is.na(d89$BI2)),sum(is.na(d89$BI3)),sum(is.na(d89$BI4)),sum(is.na(d89$BI5)),sum(is.na(d89$BI6)),sum(is.na(d89$BI7)),
         sum(is.na(d89$PE1)),sum(is.na(d89$PE2)),sum(is.na(d89$PE3)),sum(is.na(d89$PE4)),sum(is.na(d89$PE5)),sum(is.na(d89$PE6)),sum(is.na(d89$PE7)),
         sum(is.na(d89$EE1)),sum(is.na(d89$EE2)),sum(is.na(d89$EE3)),sum(is.na(d89$EE4)),sum(is.na(d89$EE5_R)),sum(is.na(d89$EE6)),
         sum(is.na(d89$SI1)),sum(is.na(d89$SI2)),sum(is.na(d89$SI3)),sum(is.na(d89$SI4)),sum(is.na(d89$SI5_R)),
         sum(is.na(d89$SE1)),sum(is.na(d89$SE2)),sum(is.na(d89$SE3)),sum(is.na(d89$SE4)),
         sum(is.na(d89$TR1)),sum(is.na(d89$TR2_R)),sum(is.na(d89$TR3)),
         sum(is.na(d89$HM1)),sum(is.na(d89$HM2_R)),sum(is.na(d89$HM3)),sum(is.na(d89$HM4)),sum(is.na(d89$HM5)),sum(is.na(d89$HM6)),sum(is.na(d89$HM7_R)),
         sum(is.na(d89$AN1_R)),sum(is.na(d89$AN2_R)),sum(is.na(d89$AN3_R)),sum(is.na(d89$AN4_R)),
         sum(is.na(d89$FC1)),sum(is.na(d89$FC2)),sum(is.na(d89$FC3)),sum(is.na(d89$FC4)))
na_89<-sort(na_89)
cat("   Outlier criteria SAAQ, NA more than Q3+1.5*IQR = ")
quantile(na_89,0.75)+1.5*IQR(na_89)
cat("   Outlier SAAQ indicators = BI4, SI3, HM6, SE2, FC3 and FC4 \n")
cat("   Note: these outliers indicators will be excluded also from the Behavior-Outcome Model and the Sleep Restriction Model \n")


cat("\n\n MISSING DATA\n\n")
cat("   Intention-Behavior Model (n=89), missing values:\n")
cat("     BI1 = ")
sum(is.na(d89$BI1))
cat("     BI2 = ")
sum(is.na(d89$BI2))
cat("     BI3 = ")
sum(is.na(d89$BI3))
cat("     BI4 = ")
sum(is.na(d89$BI4))
cat("     BI5 = ")
sum(is.na(d89$BI5))
cat("     BI6 = ")
sum(is.na(d89$BI6))
cat("     BI7 = ")
sum(is.na(d89$BI7))
cat("     PE1 = ")
sum(is.na(d89$PE1))
cat("     PE2 = ")
sum(is.na(d89$PE2))
cat("     PE3 = ")
sum(is.na(d89$PE3))
cat("     PE4 = ")
sum(is.na(d89$PE4))
cat("     PE5 = ")
sum(is.na(d89$PE5))
cat("     PE6 = ")
sum(is.na(d89$PE6))
cat("     PE7 = ")
sum(is.na(d89$PE7))
cat("     EE1 = ")
sum(is.na(d89$EE1))
cat("     EE2 = ")
sum(is.na(d89$EE2))
cat("     EE3 = ")
sum(is.na(d89$EE3))
cat("     EE4 = ")
sum(is.na(d89$EE4))
cat("     EE5-R = ")
sum(is.na(d89$EE5_R))
cat("     EE6 = ")
sum(is.na(d89$EE6))
cat("     SI1 = ")
sum(is.na(d89$SI1))
cat("     SI2 = ")
sum(is.na(d89$SI2))
cat("     SI3 = ")
sum(is.na(d89$SI3))
cat("     SI4 = ")
sum(is.na(d89$SI4))
cat("     SI5-R = ")
sum(is.na(d89$SI5_R))
cat("     SE1 = ")
sum(is.na(d89$SE1))
cat("     SE2 = ")
sum(is.na(d89$SE2))
cat("     SE3 = ")
sum(is.na(d89$SE3))
cat("     SE4 = ")
sum(is.na(d89$SE4))
cat("     TR1 = ")
sum(is.na(d89$TR1))
cat("     TR2-R = ")
sum(is.na(d89$TR2_R))
cat("     TR3 = ")
sum(is.na(d89$TR3))
cat("     HM1 = ")
sum(is.na(d89$HM1))
cat("     HM2-R = ")
sum(is.na(d89$HM2_R))
cat("     HM3 = ")
sum(is.na(d89$HM3))
cat("     HM4 = ")
sum(is.na(d89$HM4))
cat("     HM5 = ")
sum(is.na(d89$HM5))
cat("     HM6 = ")
sum(is.na(d89$HM6))
cat("     HM7-R = ")
sum(is.na(d89$HM7_R))
cat("     AN1-R = ")
sum(is.na(d89$AN1_R))
cat("     AN2-R = ")
sum(is.na(d89$AN2_R))
cat("     AN3-R = ")
sum(is.na(d89$AN3_R))
cat("     AN4-R = ")
sum(is.na(d89$AN4_R))
cat("     FC1 = ")
sum(is.na(d89$FC1))
cat("     FC2 = ")
sum(is.na(d89$FC2))
cat("     FC3 = ")
sum(is.na(d89$FC3))
cat("     FC4 = ")
sum(is.na(d89$FC4))
cat("     RE-DO = ")
sum(is.na(d89$RE_DO))
cat("     SD-DO = ")
sum(is.na(d89$SD_DO))
cat("     CONV-DO = ")
sum(is.na(d89$CONV_DO))

cat("\n   Summary of the Sleep App Acceptance Questionnaire, Excluding BI4, SI3, HM6, SE2, FC3 and FC4: \n")
BI<-data.frame(d89$PPnr, d89$conditie, d89$BI1,d89$BI2,d89$BI3,d89$BI5,d89$BI6,d89$BI7)
PE<-data.frame(d89$PPnr, d89$conditie, d89$PE1,d89$PE2,d89$PE3,d89$PE4,d89$PE5,d89$PE6,d89$PE7)
EE<-data.frame(d89$PPnr, d89$conditie, d89$EE1,d89$EE2,d89$EE3,d89$EE4,d89$EE5_R,d89$EE6)
SI<-data.frame(d89$PPnr, d89$conditie, d89$SI1,d89$SI2,d89$SI4,d89$SI5_R)
SE<-data.frame(d89$PPnr, d89$conditie, d89$SE1,d89$SE3,d89$SE4)
TR<-data.frame(d89$PPnr, d89$conditie, d89$TR1,d89$TR2_R,d89$TR3)
HM<-data.frame(d89$PPnr, d89$conditie, d89$HM1,d89$HM2_R,d89$HM3,d89$HM4,d89$HM5,d89$HM7_R)
AN<-data.frame(d89$PPnr, d89$conditie, d89$AN1_R,d89$AN2_R,d89$AN3_R,d89$AN4_R)
FC<-data.frame(d89$PPnr, d89$conditie, d89$FC1,d89$FC2)
colnames(BI)<-c('PPnr','conditie', 'BI1','BI2','BI3','BI5','BI6','BI7')
colnames(BI)<-c('PPnr', 'conditie', 'BI1','BI2','BI3','BI5','BI6','BI7')
colnames(PE)<-c('PPnr', 'conditie', 'PE1','PE2','PE3','PE4','PE5','PE6','PE7')
colnames(EE)<-c('PPnr', 'conditie', 'EE1','EE2','EE3','EE4','EE5_R','EE6')
colnames(SI)<-c('PPnr', 'conditie', 'SI1','SI2','SI4','SI5_R')
colnames(SE)<-c('PPnr', 'conditie', 'SE1','SE3','SE4')
colnames(TR)<-c('PPnr', 'conditie', 'TR1','TR2_R','TR3')
colnames(HM)<-c('PPnr', 'conditie', 'HM1','HM2_R','HM3','HM4','HM5','HM7_R')
colnames(AN)<-c('PPnr', 'conditie', 'AN1_R','AN2_R','AN3_R','AN4_R')
colnames(FC)<-c('PPnr', 'conditie', 'FC1','FC2')
SAAQ_89<-merge(BI,PE,by = c('PPnr', 'conditie'))
SAAQ_89<-merge(SAAQ_89,EE, by = c('PPnr', 'conditie'))
SAAQ_89<-merge(SAAQ_89,SI, by = c('PPnr', 'conditie'))
SAAQ_89<-merge(SAAQ_89,SE, by = c('PPnr', 'conditie'))
SAAQ_89<-merge(SAAQ_89,TR, by = c('PPnr', 'conditie'))
SAAQ_89<-merge(SAAQ_89,HM, by = c('PPnr', 'conditie'))
SAAQ_89<-merge(SAAQ_89,AN, by = c('PPnr', 'conditie'))
SAAQ_89<-merge(SAAQ_89,FC, by = c('PPnr', 'conditie'))
cat("     Total variables= 9 \n") 
cat("     Total Indicators= ")
ncol(SAAQ_89)-2
cat("     Total missing values of the Sleep App Acceptance Questionnaire= ")
sum(is.na(SAAQ_89))
cat("      % = ") 
sum(is.na(SAAQ_89))/(nrow(SAAQ_89)*(ncol(SAAQ_89)-2))*100

cat("\n   Summary Behavioural Data \n")
cat("     Total variables= 2 \n") 
cat("     Total Indicators= 3 \n")
cat("     Total missing values of the Behavioral Data= ")
sum(is.na(d89$RE_DO))+sum(is.na(d89$SD_DO))+sum(is.na(d89$CONV_DO))
cat("      % = ") 
(sum(is.na(d89$RE_DO))+sum(is.na(d89$SD_DO))+sum(is.na(d89$CONV_DO)))/(nrow(d89)*3)*100

cat("\n   TOTAL MISSING VALUES = ")
sum(is.na(SAAQ_89))+sum(is.na(d89$RE_DO))+sum(is.na(d89$SD_DO))+sum(is.na(d89$CONV_DO))
  cat("      % = ") 
(sum(is.na(SAAQ_89))+sum(is.na(d89$RE_DO))+sum(is.na(d89$SD_DO))+sum(is.na(d89$CONV_DO)))/(nrow(SAAQ_89)*(ncol(SAAQ_89)-2+3))*100

cat("\n\n################ End of Missing Data Description  ################### \n")

######### stop redirecting output.
sink()
